<?php
session_start();
include 'db.php';

$response = [
    'success' => false,
    'message' => 'Something went wrong, please try again.' 
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $productid = isset($_POST['productid']) ? (int)$_POST['productid'] : 0;
    $productname = isset($_POST['productname']) ? mysqli_real_escape_string($connection, $_POST['productname']) : '';
    $amount = isset($_POST['amount']) ? (int)$_POST['amount'] : 0;
    $taps = isset($_POST['taps']) ? (int)$_POST['taps'] : 0;
    $timedate = date("Y-m-d H:i:s");  // Capture the current timestamp
    $timeout = 1; // Timeout in seconds to determine if a new record should be created

    if ($productid > 0 && $productname && $amount > 0 && $taps > 0) {
        $checkQuery = "SELECT * FROM transacetion WHERE productid = $productid AND delete_status = 0 ORDER BY timedate DESC LIMIT 1";
        $result = mysqli_query($connection, $checkQuery);

        if (mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $lastTapTime = strtotime($row['timedate']);
            $timeDiff = time() - $lastTapTime;

            if ($timeDiff <= $timeout) {
                // Update the existing record with the new cumulative tap count and total amount
                $newTapCount = $row['taps'] + 1;
                $newTotalAmount = $amount * $newTapCount;
                $updateQuery = "UPDATE transacetion SET taps = $newTapCount,  timedate = '$timedate' WHERE id = " . $row['id'];

                if (mysqli_query($connection, $updateQuery)) {
                    $response['success'] = true;
                    $response['message'] = 'Tap count updated successfully.';
                } else {
                    $response['message'] = 'Database update failed: ' . mysqli_error($connection);
                }
            } else {
                // Insert a new record with the initial tap count
                $insertQuery = "INSERT INTO transacetion (productid, productname, amount, taps, timedate, delete_status) 
                                VALUES ($productid, '$productname', $amount,  1, '$timedate', 0)";
                
                if (mysqli_query($connection, $insertQuery)) {
                    $response['success'] = true;
                    $response['message'] = 'New tap record created successfully.';
                } else {
                    $response['message'] = 'Database insertion failed: ' . mysqli_error($connection);
                }
            }
        } else {
            // No existing record, insert a new one
            $insertQuery = "INSERT INTO transacetion (productid, productname, amount, taps, timedate, delete_status) 
                            VALUES ($productid, '$productname', $amount,  1, '$timedate', 0)";

            if (mysqli_query($connection, $insertQuery)) {
                $response['success'] = true;
                $response['message'] = 'New tap record created successfully.';
            } else {
                $response['message'] = 'Database insertion failed: ' . mysqli_error($connection);
            }
        }
    } else {
        $response['message'] = 'Invalid input data.';
    }
} else {
    $response['message'] = 'Invalid request method.';
}

echo json_encode($response);
?>
